@extends('layouts.admin')

@section('title', 'Content Management')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Content Management</h1>
    <a href="{{ route('admin.contents.create') }}" class="btn btn-primary">
        <i class="bi bi-plus-circle"></i> Add New Content
    </a>
</div>

@if($sections->count() > 0)
<div class="mb-4">
    <div class="btn-group" role="group">
        <a href="{{ route('admin.contents.index') }}" class="btn btn-outline-secondary {{ !request('section') ? 'active' : '' }}">All</a>
        @foreach($sections as $section)
            <a href="{{ route('admin.contents.index', ['section' => $section]) }}" class="btn btn-outline-secondary {{ request('section') == $section ? 'active' : '' }}">{{ ucfirst($section) }}</a>
        @endforeach
    </div>
</div>
@endif

<div class="card">
    <div class="card-body">
        @if($contents->count() > 0)
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Page Key</th>
                        <th>Section</th>
                        <th>Label</th>
                        <th>Type</th>
                        <th>Content Preview</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($contents as $content)
                    <tr>
                        <td><code>{{ $content->page_key }}</code></td>
                        <td>{{ $content->section ?? 'N/A' }}</td>
                        <td>{{ $content->label }}</td>
                        <td><span class="badge bg-info">{{ $content->type }}</span></td>
                        <td>{{ Str::limit($content->content, 50) }}</td>
                        <td>
                            <a href="{{ route('admin.contents.show', $content) }}" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i>
                            </a>
                            <a href="{{ route('admin.contents.edit', $content) }}" class="btn btn-sm btn-warning">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <form action="{{ route('admin.contents.destroy', $content) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this content?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @else
        <p class="text-muted mb-0">No content entries yet. <a href="{{ route('admin.contents.create') }}">Create your first content entry</a>.</p>
        @endif
    </div>
</div>
@endsection



